IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES
			 WHERE TABLE_NAME='EST_MOV_MOTOQ_PDV_VD')
begin
CREATE TABLE [dbo].[EST_MOV_MOTOQ_PDV_VD](
	[CD_MOV] [int] NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_VD] [int] NOT NULL,
 CONSTRAINT [PK_EST_MOV_MOTOQ_PDV_VD] PRIMARY KEY CLUSTERED 
(
	[CD_MOV] ASC,
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_VD] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[EST_MOV_MOTOQ_PDV_VD] ADD  CONSTRAINT [DF_EST_MOV_MOTOQ_PDV_VD_CD_MOV]  DEFAULT ((0)) FOR [CD_MOV]

ALTER TABLE [dbo].[EST_MOV_MOTOQ_PDV_VD] ADD  CONSTRAINT [DF_EST_MOV_MOTOQ_PDV_VD_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_MOV_MOTOQ_PDV_VD] ADD  CONSTRAINT [DF_EST_MOV_MOTOQ_PDV_VD_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[EST_MOV_MOTOQ_PDV_VD] ADD  CONSTRAINT [DF_EST_MOV_MOTOQ_PDV_VD_CD_VD]  DEFAULT ((0)) FOR [CD_VD]

ALTER TABLE [dbo].[EST_MOV_MOTOQ_PDV_VD]  WITH CHECK ADD  CONSTRAINT [FK_EST_MOV_MOTOQ_PDV_VD_EST_MOV_MOTOQ] FOREIGN KEY([CD_MOV])
REFERENCES [dbo].[EST_MOV_MOTOQ] ([CD_MOV])

ALTER TABLE [dbo].[EST_MOV_MOTOQ_PDV_VD] CHECK CONSTRAINT [FK_EST_MOV_MOTOQ_PDV_VD_EST_MOV_MOTOQ]

ALTER TABLE [dbo].[EST_MOV_MOTOQ_PDV_VD]  WITH CHECK ADD  CONSTRAINT [FK_EST_MOV_MOTOQ_PDV_VD_PDV_VD] FOREIGN KEY([CD_VD], [CD_FILIAL], [CD_EMP])
REFERENCES [dbo].[PDV_VD] ([CD_VD], [CD_FILIAL], [CD_EMP])

ALTER TABLE [dbo].[EST_MOV_MOTOQ_PDV_VD] CHECK CONSTRAINT [FK_EST_MOV_MOTOQ_PDV_VD_PDV_VD]
END